package com.humandevice.android.appcrashhandler;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;


/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-06-29
 */
public class ExceptionActivity extends Activity {

	public static final String EXTRA_EXCEPTION = "extra_exception";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		final Throwable e = (Throwable) getIntent().getSerializableExtra(EXTRA_EXCEPTION);

		new AlertDialog.Builder(ExceptionActivity.this, android.R.style.Theme_DeviceDefault_Light_Dialog_MinWidth)
				.setTitle("Unfortunately, application has stopped.")
				.setMessage(Log.getStackTraceString(e))
				.setPositiveButton("Send report", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialogInterface, int i) {
						Intent intent = new Intent(Intent.ACTION_SEND);
						intent.setType("plain/text");
						intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						intent.putExtra(Intent.EXTRA_TEXT, "/code " + Log.getStackTraceString(e));
						startActivity(intent);
						finish();
					}
				})
				.setNegativeButton("Close", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialogInterface, int i) {
						finish();
					}
				})
				.show();
	}

}
