package com.humandevice.android.appcrashhandler;

import android.app.Application;
import android.content.Context;
import android.content.Intent;

/**
 * Uncaught exception handler. This handler is invoked in case any Thread dies due to an unhandled exception.
 *
 * @author Rafal Zajfert
 * @date 2016-06-29
 */
public class AppCrashHandler implements Thread.UncaughtExceptionHandler {

	private static Context mContext;

	public AppCrashHandler() {
	}

	/**
	 * Sets as the default uncaught exception handler. This handler is invoked in case any Thread dies due to an unhandled exception.
	 */
	public static void setAsDefault() {
		Thread.setDefaultUncaughtExceptionHandler(new AppCrashHandler());
	}

	@Override
	public void uncaughtException(Thread thread, Throwable throwable) {
		Intent crashedIntent = new Intent(getContext(), ExceptionActivity.class);
		crashedIntent.putExtra(ExceptionActivity.EXTRA_EXCEPTION, throwable);
		crashedIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
		getContext().startActivity(crashedIntent);
		System.exit(1);

	}

	private static Context getContext() {
		if (mContext == null) {
			try {
				mContext = (Application) Class.forName("android.app.ActivityThread").getMethod("currentApplication").invoke(null, (Object[]) null);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return mContext;
	}

}
