package com.humandevice.android.appversioncontrol;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.Html;
import android.text.Spanned;

import java.util.Locale;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-09-08
 */
public class AppVersionControl {

	public static void checkAppVersion(@NonNull final Context context, @NonNull final VersionListener listener) {
		new Thread(new Runnable() {
			@Override
			public void run() {
				final AppVersion latestVersion = listener.getLatestVersion();
				if (latestVersion != null) {
					new Handler(Looper.getMainLooper()).post(new Runnable() {
						@Override
						public void run() {
							int version = getAppVersion(context);
							if (latestVersion.isOld(version)) {
								String messageString;
								if (latestVersion.getExpiration()!=null){
									messageString = context.getString(latestVersion.isCriticalOld(version) ? R.string.too_old_app_message : R.string.old_app_message, getAppName(context), String.format(Locale.US, "<b>%1$tb %1$te, %1$tY</b>", latestVersion.getExpiration()));
								} else {
									messageString = context.getString(latestVersion.isCriticalOld(version) ? R.string.too_old_app_short_message : R.string.old_app_short_message, getAppName(context));
								}
								CharSequence message = fromHtml(messageString);
								OldVersionDialog.Builder dialog = new OldVersionDialog.Builder(context)
										.setCritical(latestVersion.isCriticalOld(version))
										.setCancelable(!latestVersion.isCriticalOld(version))
										.setMessage(message);
								listener.onAppVersionOutDated(dialog, latestVersion.isCriticalOld(version));
							} else {
								listener.onAppVersionValid();
							}
						}
					});
				}
			}
		}).start();
	}

	public static Spanned fromHtml(String source) {
		Spanned spanned;
		if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
			spanned = Html.fromHtml(source, Html.FROM_HTML_MODE_LEGACY);
		} else {
			spanned = Html.fromHtml(source);
		}
		return spanned;
	}

	private static int getAppVersion(Context context) {
		try {
			return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
		} catch (PackageManager.NameNotFoundException e) {
			return 0;
		}
	}

	private static String getAppName(Context context) {
		int stringId = context.getApplicationInfo().labelRes;
		return context.getString(stringId);
	}

	public interface VersionListener {
		@WorkerThread
		AppVersion getLatestVersion();

		@UiThread
		void onAppVersionOutDated(OldVersionDialog.Builder dialog, boolean critical);

		void onAppVersionValid();
	}

}
