package com.humandevice.android.core.tools;

import android.util.Log;

/**
 * Simple logger wrapper for libraries
 *
 * @author Mikołaj Styś
 * @date 2016/04/20
 */
public class DefaultLogger implements Logger {

    private boolean mLogging;
    private String mTag;

    private DefaultLogger(String tag) {
        mLogging = false;
        mTag = tag;
    }

    @Override
    public boolean isLogging() {
        return mLogging;
    }

    @Override
    public void setLogging(boolean enable) {
        mLogging = true;
    }

    @Override
    public void debug(Object... items) {
        if(!mLogging) {
            return;
        }
        Log.d(mTag, consolidate(items));
    }

    private static String consolidate(Object... items) {
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(String.valueOf(item)).append(" ");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    @Override
    public void info(Object... items) {
        if(!mLogging) {
            return;
        }
        Log.i(mTag, consolidate(items));
    }

    @Override
    public void warning(Object... items) {
        Log.w(mTag, consolidate(items));
    }

    @Override
    public void error(Object... items) {
        Log.e(mTag, consolidate(items));
    }
}
