package com.humandevice.android.core.tools;

/**
 * Created by Szymon on 2016-02-01.
 * Simple lock to ensure sequential processing in some cases
 */
public class ThreadLock {

    private static ThreadLock sInstance = new ThreadLock();

    public static ThreadLock getInstance() {
        return sInstance;
    }

    private boolean isLocked = false;

    public synchronized void lock()
            throws InterruptedException{
        waitIfLocked();
        isLocked = true;
    }

    public synchronized void unlock(){
        isLocked = false;
        notify();
    }

    public synchronized void waitIfLocked() throws InterruptedException {
        while(isLocked){
            wait();
        }
    }
}
