package com.humandevice.android.core.view.interfaces;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;

import com.humandevice.android.core.view.annotation.GuiContext;

/**
 * Interface states that implementing class hav context, which can be obtained using getContext();
 *
 * @author Mikołaj Styś
 * @date 2016/04/21
 */
public interface ContextOperator extends ContextHolder {

    @Override
    @GuiContext
    Context getContext();

    void startActivityForResult(Intent intent, int requestCode, @Nullable Bundle options);

    View getRootView();

}
