package com.humandevice.android.core.adapters;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Custom annotations that can be used with Transformer tools
 * Date: 2016/01/28
 *
 * @author Mikołaj Styś
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Serialized {
    String EMPTY = "__null";

    String value() default EMPTY;

    String view() default EMPTY;

    String rest() default EMPTY;

    String database() default EMPTY;
}
