package com.humandevice.android.core.tools;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;

import com.humandevice.android.core.view.annotation.AppContext;
import com.humandevice.android.core.view.annotation.GuiContext;

import java.util.List;

/**
 * Provides utils related to Android environment ex. is device online
 *
 * @author Mikołaj Styś
 * @date 2016/04/20
 */
public class StateUtils {

    private StateUtils() {

    }

    public static boolean isServiceRunning(Class<?> serviceClass, @AppContext @NonNull Context context) {
        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }

    /**
     * @return is app connected to the Internet
     */
    public static boolean isOnline(@AppContext @NonNull Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @RequiresPermission("android.permission.ACCESS_WIFI_STATE")
    public static boolean checkWifiOnAndConnected(@AppContext @NonNull Context context) {
        WifiManager wifiMgr = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if (wifiMgr.isWifiEnabled()) {
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            return wifiInfo.getNetworkId() != -1;
        } else {
            return false;
        }
    }

    public static boolean destinationActivityExist(@AppContext @NonNull Context context, Intent intent) {
        List<ResolveInfo> list = context
                .getPackageManager().queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY);
        return list.size() > 0;
    }

    public static boolean isLandscape(@GuiContext @NonNull Context context) {
        Point point = new Point();
        ((Activity) context).getWindowManager().getDefaultDisplay().getSize(point);
        return point.x > point.y;
    }
}
