package com.humandevice.android.core.tools;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.humandevice.android.core.view.annotation.AppContext;

/**
 * By Quantum on 06/2015.
 */
public class ViewUtils {

    private ViewUtils() {

    }

    public static Drawable paintDrawable(@DrawableRes int drawableId, @ColorInt int color, @AppContext Context context) {
        Drawable result = ResourcesCompat.getDrawable(context.getResources(), drawableId, null);
        if (result != null) {
            result.setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
        return result;
    }

    public static int dpToPx(float dp) {
        return (int) (dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static float pxToDp(int px) {
        return px / Resources.getSystem().getDisplayMetrics().density;
    }

    /**
     * Hide software keyboard
     */
    public static void hideKeyboard(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager inputManager = (InputMethodManager) view.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        inputManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
    }

    /**
     * Show software keyboard
     */
    public static void showKeyboard(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager inputManager = (InputMethodManager) view.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        inputManager.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT);
    }

    @ColorInt
    public static int getColor(@AppContext @NonNull Context context, @ColorRes int colorResource) {
        return ContextCompat.getColor(context, colorResource);
    }
}
