package com.humandevice.android.core.view;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.humandevice.android.core.view.interfaces.ActivityResultListener;
import com.humandevice.android.core.view.interfaces.BackListener;
import com.humandevice.android.core.view.interfaces.ContextOperator;


/**
 * Base fragment inherited by all other fragments in app
 *
 * @author Mikołaj Styś
 */
public abstract class ToolsFragment extends Fragment
        implements BackListener, ActivityResultListener, ContextOperator {

    @Override
    /**
     * Overridden version of M's getContext - works with previous versions.
     */
    public Context getContext() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            return getActivity();
        } else {
            return super.getContext();
        }
    }

    @SuppressWarnings("deprecation")
    @Override
    public final void onAttach(Activity activity) {
        super.onAttach(activity);
        onAttachToFragment(activity);
    }

    @Override
    public final void onAttach(Context context) {
        super.onAttach(context);
        onAttachToFragment(context);
    }

    /**
     * @param context context of activity that attached fragment
     */
    public void onAttachToFragment(Context context) {

    }

    @Override
    public void onActivityResultPropagated(int requestCode, int resultCode, @Nullable Intent data) {

    }

    @Override
    public View getRootView() {
        return super.getView();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public boolean onBackPressedPropagated() {
        return false;
    }
}
