package com.humandevice.android.database;

import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;

import com.humandevice.android.database.dao.AbstractDao;

/**
 * Works a bit like configuration file - you have to provide database info
 * and order for creating daos.
 * @author Mikołaj Styś
 * @date 2016-05-05
 */
public abstract class DatabaseConfiguration {

    public abstract String getDatabaseName();

    public abstract int getDatabaseVersion();

    public boolean enableLogging() {
        return true;
    }

    @NonNull
    protected abstract AbstractDao[] initDaos();


    public void onCreate(SQLiteDatabase db, AbstractDao[] includedDaos) {
        for (AbstractDao dao : includedDaos) {
            dao.onTableCreate(db);
        }
        onPostCreate(db, includedDaos);
    }

    public void onPostCreate(SQLiteDatabase db, AbstractDao[] includedDaos) {
        for (AbstractDao dao : includedDaos) {
            dao.onPostCreate(db);
        }
    }


    public void onConfigure(SQLiteDatabase db, AbstractDao[] includedDaos) {
        db.setForeignKeyConstraintsEnabled(true);
    }

    public void onDelete(SQLiteDatabase db, AbstractDao[] includedDaos) {
        for (int i = includedDaos.length - 1; i >= 0; --i) {
            db.execSQL("DROP TABLE IF EXISTS " + includedDaos[i].getTableName());
        }
    }

    public void onUpgrade(SQLiteDatabase db, AbstractDao[] includedDaos) {
        onDelete(db, includedDaos);
        onCreate(db, includedDaos);
    }

    public void onDowngrade(SQLiteDatabase db, AbstractDao[] includedDaos) {
        onUpgrade(db, includedDaos);
    }
}
