package com.humandevice.android.database;

/**
 * List all sqllite on Delete / on Update actions
 * @author Mikołaj Styś
 * @date 2015-09-05.
 */
public enum SqlForeignKeyActions {
    NO_ACTION("NO ACTION"),
    RESTRICT("RESTRICT"),
    SET_NULL("SET NULL"),
    SET_DEFAULT("SET DEFAULT"),
    CASCADE("CASCADE");

    private final String action;

    SqlForeignKeyActions(String action) {
        this.action = action;
    }

    public String getSqlName() {
        return action;
    }

    @Override
    public String toString() {
        return action;
    }
}
