package com.humandevice.android.database.model;


import com.humandevice.android.database.annotations.Id;

import java.io.Serializable;


/**
 * By Mikołaj Styś
 * Convenient implementation of {@link LocalIdentifiable}
 */
public abstract class EntityWithId implements LocalIdentifiable, Serializable {

    @Id
    protected long _id;

    public EntityWithId() {
        this(INVALID_ID);
    }

    public EntityWithId(long id) {
        setDatabaseId(id);
    }

    public boolean existInDatabase() {
        return getDatabaseId() > INVALID_ID;
    }

    @Override
    public void setDatabaseId(long id) {
        _id = id;
    }

    @Override
    public long getDatabaseId() {
        return _id;
    }
}
