package com.humandevice.android.database.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * States that this field should be treated as Primary Key (integer).
 * This is an equivalent of @Serialized(database = AbstractDao.ID).
 * #isAutoIncrement states that primary key will be autoincrement, default true
 *
 * @author Mikołaj Styś
 * @date 06.06.2016
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Id {
    boolean isAutoIncrement() default true;
}