package com.humandevice.android.database.tools;

import android.support.annotation.Nullable;

import com.humandevice.android.core.adapters.Serialized;
import com.humandevice.android.database.annotations.Id;
import com.humandevice.android.database.dao.AbstractDao;

import java.lang.reflect.Field;

import static com.humandevice.android.core.adapters.Serialized.EMPTY;

/**
 * Helps extracting annotations values
 * @date 2016/01/28
 * @author Mikołaj Styś
 */
public class DatabaseAnnotationHelper {

    private boolean isSet(final String name) {
        return !EMPTY.equals(name);
    }

    private boolean isNotSet(final String name) {
        return EMPTY.equals(name);
    }

    @Nullable
    public String getDatabaseName(final Field field) {
        if (field.getAnnotation(Id.class) != null) {
            return AbstractDao.ID;
        }
        Serialized annotation = field.getAnnotation(Serialized.class);
        if (annotation == null) {
            return null;
        } else if (isSet(annotation.value())) {
            return annotation.value();
        } else if (isSet(annotation.database())) {
            return annotation.database();
        } else if (field.isEnumConstant() || (isNotSet(annotation.rest()) && isNotSet(annotation.view()))) {
            return field.getName();
        } else {
            return null;
        }
    }

    private Field getEnumField(Field field, Object model) throws NoSuchFieldException, IllegalAccessException {
        String result = ((Enum<?>) field.get(model)).name();
        return field.getType().getField(result);
    }

    @Nullable
    public String getEnumDatabaseName(Field field, Object model) throws IllegalAccessException, NoSuchFieldException {
        return getDatabaseName(getEnumField(field, model));
    }

    public Enum<?> getEnumFromDatabaseName(Field field, String databaseName) throws IllegalAccessException {
        for (Field enumField : field.getType().getFields()) {
            if (databaseName.equalsIgnoreCase(getDatabaseName(enumField)) || databaseName.equalsIgnoreCase(enumField.getName())) {
                return (Enum<?>) enumField.get(field);
            }
        }
        return null;
    }

    public String getEnumDatabaseName(Enum<?> enumObject) {
        String field = enumObject.name();
        try {
            getDatabaseName(enumObject.getClass().getField(field));
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    public boolean isAutoincrement(Field field) {
        Id annotation = field.getAnnotation(Id.class);
        return annotation != null && annotation.isAutoIncrement();
    }
}
