package com.humandevice.android.database;

import android.app.Application;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.humandevice.android.database.dao.AbstractDao;

import java.lang.reflect.Field;

/**
 * Works a bit like configuration file - you have to provide database info
 * and order for creating daos.
 * @author Mikołaj Styś
 * @date 2015-09-05
 */
public final class DatabaseHelper extends SQLiteOpenHelper {

    private DatabaseConfiguration mDatabaseConfiguration;
    private AbstractDao[] mDaos;

    public DatabaseHelper(Application context, DatabaseConfiguration configuration) {
        super(context, configuration.getDatabaseName(), null, configuration.getDatabaseVersion());
        mDatabaseConfiguration = configuration;
        enableLogging();
    }

    private void enableLogging() {
        if (mDatabaseConfiguration.enableLogging()) {
            try {
                Class<?> sqliteDebugClass = Class.forName("android.database.sqlite.SQLiteDebug");
                Field field;
                field = sqliteDebugClass.getDeclaredField("DEBUG_SQL_STATEMENTS");
                field.setAccessible(true);
                field.set(null, true);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AbstractDao[] getIncludedDaos() {
        if(mDaos == null) {
            mDaos = mDatabaseConfiguration.initDaos();
        }
        return mDaos;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        mDatabaseConfiguration.onCreate(db, getIncludedDaos());
    }

    @Override
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        mDatabaseConfiguration.onConfigure(db, getIncludedDaos());
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        mDatabaseConfiguration.onUpgrade(db, getIncludedDaos());
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        mDatabaseConfiguration.onDowngrade(db, getIncludedDaos());
    }

}
