package com.humandevice.android.database.tools;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Utils for reflect transformations
 * @date 2016/01/28
 * @author Mikołaj Styś
 */
public class ReflectTypeUtils {

    public static boolean isFloatingPoint(Class type) {
        return isFloat(type) || isDouble(type);
    }

    public static boolean isFloat(Class type) {
        return float.class.equals(type) || Float.class.equals(type);
    }

    public static boolean isDate(Class type) {
        return Date.class.equals(type) || Calendar.class.equals(type);
    }

    public static boolean isDouble(Class type) {
        return Double.class.equals(type) || double.class.equals(type);
    }

    public static boolean isFixedPrecision(Class type) {
        return int.class.equals(type) || Integer.class.equals(type) ||
                Short.class.equals(type) || short.class.equals(type) ||
                byte.class.equals(type) || Byte.class.equals(type) ||
                isLong(type);
    }

    public static boolean isLong(Class type) {
        return long.class.equals(type) || Long.class.equals(type);
    }

    public static boolean isBoolean(Class type) {
        return Boolean.class.equals(type) || boolean.class.equals(type);
    }

    public static boolean isString(Class type) {
        return String.class.equals(type);
    }

    public static boolean isByteArray(Class type) {
        return byte[].class.equals(type) || Byte[].class.equals(type);
    }

    public static boolean isEnum(Class type) {
        return type.isEnum();
    }


    public static List<Field> getAllFields(Class<?> entityClass) {
        List<Field> result = new ArrayList<>();
        Class<?> i = entityClass;
        while (i != null && i != Object.class) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
            i = i.getSuperclass();
        }
        return result;
    }
}
