package com.humandevice.android.formvalidator;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.view.View;
import android.widget.TextView;

import com.humandevice.android.formvalidator.rules.Rule;
import com.humandevice.android.formvalidator.utils.FormValidatorUtils;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
@SuppressWarnings("unused")
public class RealTimeFormValidator extends FormValidator {

    /**
     * <b>Uwaga:</b> Validator musi ustawić własny focus change listener, jeśli potrzebne jest dodanie tego listenera to musi być to
     * zrobione przed wywołaniem metody {@link FormValidator#addRule(View, Rule)}
     */
    public RealTimeFormValidator() {
    }

    @Override
    protected void init(@NonNull View view) {
        super.init(view);
        initFocusChangeListener(view);
    }

    private void initFocusChangeListener(@NonNull View view) {
        View.OnFocusChangeListener onFocusChangeListener = view.getOnFocusChangeListener();
        if (onFocusChangeListener != null && !(onFocusChangeListener instanceof ValidatorOnFocusChangeListener)){
            view.setOnFocusChangeListener(new ValidatorOnFocusChangeListener(onFocusChangeListener));
        }else if (onFocusChangeListener == null){
            view.setOnFocusChangeListener(new ValidatorOnFocusChangeListener());
        }
    }

    @Override
    protected void initTextWatcher(@NonNull TextView view) {

    }

    private void validate(View v) {
        errors.remove((String) v.getTag());
        validateView(v, Integer.MAX_VALUE);
        if (errors.hasErrors((String) v.getTag())) {
            FormValidatorUtils.showViewErrors(null, v, errors, false);
        } else {
            removeErrors(v);
        }
    }

    private void removeErrors(View v) {
        if (v instanceof TextView) {
            ((TextView) v).setError(null);
        }
        if (v.getParent() instanceof TextInputLayout) {
            ((TextInputLayout) v.getParent()).setError(null);
            ((TextInputLayout) v.getParent()).setErrorEnabled(false);
        }
    }


    private class ValidatorOnFocusChangeListener implements View.OnFocusChangeListener {

        @Nullable
        private View.OnFocusChangeListener customFocusChangeListener;

        public ValidatorOnFocusChangeListener() {
        }

        public ValidatorOnFocusChangeListener(@Nullable View.OnFocusChangeListener customFocusChangeListener) {
            this.customFocusChangeListener = customFocusChangeListener;
        }

        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            notifyListener(v, hasFocus);
            if (!hasFocus) {
                validate(v);
            }
        }

        private void notifyListener(View v, boolean hasFocus) {
            if (customFocusChangeListener != null) {
                customFocusChangeListener.onFocusChange(v, hasFocus);
            }
        }
    }

}
