package com.humandevice.android.formvalidator.errors;


import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public abstract class FormError {

    private int code;

    @Nullable
    private String fieldTag;

    @NonNull
    private String message;

    public FormError(int code, @Nullable String fieldTag, @NonNull String message) {
        this.code = code;
        this.fieldTag = fieldTag;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    @Nullable
    public String getFieldTag() {
        return fieldTag;
    }

    @NonNull
    public String getMessage() {
        return message;
    }

    public boolean isAssignedToField(){
        return fieldTag != null;
    }
}
