package com.humandevice.android.formvalidator.errors;

import android.support.annotation.NonNull;
import android.view.View;

/**
 * Created by Rafal Zajfert on 06.11.2015.
 */
public class ViewFormErrorException extends Exception {
    @NonNull
    private ViewFormError formError;

    public ViewFormErrorException(@NonNull ViewFormError formError) {
        this.formError = formError;
    }

    public ViewFormErrorException(View view, String message) throws ViewFormErrorException{
        this(view, -1, message);
    }

    public ViewFormErrorException(View view, int code, String message) throws ViewFormErrorException{
        throw new ViewFormErrorException(new ViewFormError(code, (String) view.getTag(), message));
    }

    @NonNull
    public ViewFormError getFormError() {
        return formError;
    }
}
