package com.humandevice.android.formvalidator.rules;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CompoundButton;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;
import com.humandevice.android.formvalidator.utils.FormValidatorUtils;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class CheckedRule extends Rule<CheckedRule> {

    public CheckedRule() {
    }

    @Override
    public void checkView(@NonNull View view) throws ViewFormErrorException {
        Object value = FormValidatorUtils.getValue(view);
        if (value != null && value instanceof Boolean && !((Boolean) value)) {
            throw new ViewFormErrorException(view, message);
        }
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
        if (!(view instanceof CompoundButton)) {
            throw new IllegalArgumentException("View must extends CompoundButton");
        }
    }
}
