package com.humandevice.android.formvalidator.rules;

import android.support.annotation.NonNull;
import android.view.View;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class CustomRule extends Rule<CustomRule> {

    private RuleChecker ruleChecker;

    public CustomRule(@NonNull RuleChecker ruleChecker) {
        this.ruleChecker = ruleChecker;
    }

    @Override
    protected void checkView(View view) throws ViewFormErrorException {
        if (!ruleChecker.isValid(view)) {
            throw new ViewFormErrorException(view, message);
        }
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
    }

    public static interface RuleChecker {

        /**
         * Method should check if value of the view is valid or not
         *
         * @param view View associated with this rule
         * @return true if value is valid, false otherwise
         */
        boolean isValid(View view);
    }
}