package com.humandevice.android.formvalidator.rules;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;
import com.humandevice.android.formvalidator.utils.FormValidatorUtils;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class EqualsRule extends Rule<EqualsRule> {


    private final Object value;

    public EqualsRule(@NonNull View view) {
        this.value = view;
    }

    public EqualsRule(@Nullable Object value) {
        this.value = value;
    }

    @Override
    public void checkView(@NonNull View view) throws ViewFormErrorException {
        Object value = FormValidatorUtils.getValue(view);
        Object otherValue = getOtherValue(this.value);

        if (!isEqual(value, otherValue)) {
            throw new ViewFormErrorException(view, message);
        }
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
    }

    private Object getOtherValue(Object value) {
        Object otherValue;
        if (value instanceof View) {
            otherValue = FormValidatorUtils.getValue((View) this.value);
        } else {
            otherValue = this.value;
        }
        return otherValue;
    }

    protected boolean isEqual(Object value1, Object value2) {
        return (value1 == null) ? (value2 == null) : value1.equals(value2);
    }
}
