package com.humandevice.android.formvalidator.rules;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;
import com.humandevice.android.formvalidator.utils.FormValidatorUtils;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class LengthRule extends Rule<LengthRule> {

    private Integer min;
    private Integer max;

    private boolean allowEmpty = false;

    public LengthRule(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void checkView(View view) throws ViewFormErrorException {
        String text = (String) FormValidatorUtils.getValue(view);
        if (!(allowEmpty && TextUtils.isEmpty(text)) && FormValidatorUtils.isShorter(text, min) || FormValidatorUtils.isLonger(text, max)) {
            throw new ViewFormErrorException(view, message);
        }
    }

    public LengthRule allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
        if (!(view instanceof TextView)) {
            throw new IllegalArgumentException("View must extends TextView");
        }
    }
}
