package com.humandevice.android.formvalidator.rules;

import android.view.View;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;

import java.util.Collection;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class NotEmptyListRule<E> extends Rule<NotEmptyListRule<E>> {

    private Collection<E> collection;

    public NotEmptyListRule(Collection<E> collection) {
        this.collection = collection;
    }

    @Override
    protected void checkView(View view) throws ViewFormErrorException {
        if (collection == null || collection.isEmpty()) {
            throw new ViewFormErrorException(view, message);
        }
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
    }
}
