package com.humandevice.android.formvalidator.rules;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.humandevice.android.formvalidator.errors.ViewFormErrorException;
import com.humandevice.android.formvalidator.utils.FormValidatorUtils;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class NotEmptyRule extends Rule<NotEmptyRule> {
    @Override
    protected void checkView(View view) throws ViewFormErrorException {
        String text = (String) FormValidatorUtils.getValue(view);
        if (TextUtils.isEmpty(text)) {
            throw new ViewFormErrorException(view, message);
        }
    }

    @Override
    protected void checkInstance(View view) throws IllegalArgumentException {
        if (!(view instanceof TextView)) {
            throw new IllegalArgumentException("View must extends TextView");
        }
    }
}
