package com.humandevice.android.formvalidator.utils;

import android.app.Activity;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsSpinner;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.humandevice.android.formvalidator.errors.FormErrors;

import java.util.Collection;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class FormValidatorUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isLonger(String string, Integer maxLength) {
        if (string == null || maxLength == null) {
            return false;
        }
        return !TextUtils.isEmpty(string) && string.length() > maxLength;
    }

    public static boolean isShorter(String string, Integer minLength) {
        if (string == null || minLength == null) {
            return false;
        }
        return TextUtils.isEmpty(string) || string.length() < minLength;
    }

    public static Object getValue(View view) {
        if (view instanceof CompoundButton) {
            return ((CompoundButton) view).isChecked();
        } else if (view instanceof TextView) {
            return ((TextView) view).getText().toString();
        } else if (view instanceof AbsSpinner) {
            return ((AbsSpinner) view).getSelectedItem();
        } else if (view instanceof RadioGroup) {
            ((RadioGroup) view).getCheckedRadioButtonId();
        }
        return null;
    }

    public static void showErrors(View parent, FormErrors errors) {
        showErrors(parent, errors, false);
    }

    public static void showErrors(View parent, FormErrors errors, boolean useSnacks) {
        View focusView = null;
        for (String fieldTag : errors.getFieldTagsWithError()) {
            View view = parent.findViewWithTag(fieldTag);
            if (view != null) {
                if (focusView == null) {
                    focusView = view;
                }
                showViewErrors(parent, view, errors, useSnacks);
            } else {
                showNonInputError(parent, errors.getCombinedMessage(fieldTag), useSnacks);
            }
        }
        if (focusView != null) {
            focusView.requestFocus();
        }
    }

    public static void showViewErrors(View parent, View view, FormErrors errors, boolean useSnacks) {
        String message = errors.getCombinedMessage((String) view.getTag());
        ViewParent viewParent = view.getParent();
        if (viewParent instanceof TextInputLayout) {
            if (!message.equals(((TextInputLayout) viewParent).getError())) {
                ((TextInputLayout) viewParent).setErrorEnabled(true);
                ((TextInputLayout) viewParent).setError(message);
            }
        } else if (view instanceof EditText) {
            ((EditText) view).setError(message);
        } else {
            if (view instanceof TextView) {
                ((TextView) view).setError(message);
            }
            if (parent == null) {
                parent = view;
            }
            showNonInputError(parent, message, useSnacks);
        }
    }

    private static void showNonInputError(View parent, String message, boolean useSnacks) {

        if (useSnacks) {
            View contentView = parent.findViewById(android.R.id.content);
            if (contentView != null) {
                Snackbar.make(parent, message, Snackbar.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(parent.getContext(), message, Toast.LENGTH_LONG).show();
        }
    }

    /**
     * @return activity's parent view
     */
    public static ViewGroup getRootView(Activity activity) {
        return (ViewGroup) activity.findViewById(android.R.id.content);
    }
}
