package com.humandevice.maskwatcher;


/**
 * @author Rafal Zajfert
 */
class Char {
	private static final char LETTER = 'A';
	private static final char LETTER_OPTIONAL = 'a';

	private static final char DIGIT = '0';
	private static final char DIGIT_OPTIONAL = '9';

	private static final char ANY = '*';
	private static final char ANY_OPTIONAL = '?';

	private boolean mValuable;

	private boolean mOptional;

	private boolean mUpperCase;

	private boolean mLowerCase;

	private Character mValue;

	Char() {
	}

	boolean isValid(char c) {
		return true;
	}

	char getValue() {
		if (mValue == null){
			return 0;
		}
		if (mUpperCase){
			return Character.toUpperCase(mValue);
		}
		if (mLowerCase){
			return Character.toLowerCase(mValue);
		}
		return mValue;
	}

	void setValue(char value) {
		mValue = value;
	}

	void removeValue() {
		mValue = null;
	}

	boolean hasValue() {
		return mValue != null;
	}

	boolean isValuable() {
		return mValuable;
	}

	boolean isOptional() {
		return mOptional;
	}

	public boolean isUpperCase() {
		return mUpperCase;
	}

	public boolean isLowerCase() {
		return mLowerCase;
	}

	@Override
	public String toString() {
		return mValue == null ? "" : String.valueOf(getValue());
	}

	static class Builder {
		private Character mMaskChar;
		private boolean mValuable;
		private boolean mUpperCase;
		private boolean mLowerCase;
		private Character mValue;

		Builder() {
		}

		Builder(char maskChar) {
			mMaskChar = maskChar;
		}

		Builder setValue(char value) {
			mValue = value;
			return this;
		}

		Builder setValuable(boolean valuable) {
			mValuable = valuable;
			return this;
		}

		Builder setCase(Boolean upper) {
			if (upper == null) {
				mUpperCase = false;
				mLowerCase = false;
			} else if (upper) {
				mUpperCase = true;
				mLowerCase = false;
			} else {
				mUpperCase = false;
				mLowerCase = true;
			}
			return this;
		}

		Builder setUpperCase(boolean upperCase) {
			mUpperCase = upperCase;
			return this;
		}

		Builder setLowerCase(boolean lowerCase) {
			mLowerCase = lowerCase;
			return this;
		}

		Char build() {
			Char result;
			if (mMaskChar == null) {
				result = new Const();
			} else {
				switch (mMaskChar) {
					case LETTER:
						result = new Letter();
						break;
					case LETTER_OPTIONAL:
						result = new Letter();
						result.mOptional = true;
						break;
					case DIGIT:
						result = new Digit();
						break;
					case DIGIT_OPTIONAL:
						result = new Digit();
						result.mOptional = true;
						break;
					case ANY:
						result = new Char();
						break;
					case ANY_OPTIONAL:
						result = new Char();
						result.mOptional = true;
						break;
					default:
						result = new Const();
						if (mValue == null) {
							mValue = mMaskChar;
						}
				}
			}
			result.mValue = mValue;
			result.mValuable = mValuable;
			result.mUpperCase = mUpperCase;
			result.mLowerCase = mLowerCase;

			return result;
		}
	}
}
