package com.humandevice.maskwatcher;


/**
 * @author Rafal Zajfert
 */
class Char {
	private static final char LETTER = 'A';
	private static final char LETTER_OPTIONAL = 'a';

	private static final char DIGIT = '0';
	private static final char DIGIT_OPTIONAL = '9';

	private static final char ANY = '*';
	private static final char ANY_OPTIONAL = '?';

	private boolean valuable;

	private boolean optional;

	private boolean upperCase;

	private boolean lowerCase;

	private Character value;

	Char() {
	}

	boolean isValid(char c) {
		return true;
	}

	char getValue() {
		if (value == null){
			return 0;
		}
		if (upperCase){
			return Character.toUpperCase(value);
		}
		if (lowerCase){
			return Character.toLowerCase(value);
		}
		return value;
	}

	void setValue(char value) {
		this.value = value;
	}

	void removeValue() {
		value = null;
	}

	boolean hasValue() {
		return value != null;
	}

	boolean isValuable() {
		return valuable;
	}

	boolean isOptional() {
		return optional;
	}

	public boolean isUpperCase() {
		return upperCase;
	}

	public boolean isLowerCase() {
		return lowerCase;
	}

	@Override
	public String toString() {
		return value == null ? "" : String.valueOf(getValue());
	}

	static class Builder {
		private Character mMaskChar;
		private boolean mValuable;
		private boolean mUpperCase;
		private boolean mLowerCase;
		private Character mValue;

		Builder() {
		}

		Builder(char maskChar) {
			mMaskChar = maskChar;
		}

		Builder setValue(char value) {
			mValue = value;
			return this;
		}

		Builder setValuable(boolean valuable) {
			mValuable = valuable;
			return this;
		}

		Builder setCase(Boolean upper) {
			if (upper == null) {
				mUpperCase = false;
				mLowerCase = false;
			} else if (upper) {
				mUpperCase = true;
				mLowerCase = false;
			} else {
				mUpperCase = false;
				mLowerCase = true;
			}
			return this;
		}

		Builder setUpperCase(boolean upperCase) {
			mUpperCase = upperCase;
			return this;
		}

		Builder setLowerCase(boolean lowerCase) {
			mLowerCase = lowerCase;
			return this;
		}

		Char build() {
			Char result;
			if (mMaskChar == null) {
				result = new Const();
			} else {
				switch (mMaskChar) {
					case LETTER:
						result = new Letter();
						break;
					case LETTER_OPTIONAL:
						result = new Letter();
						result.optional = true;
						break;
					case DIGIT:
						result = new Digit();
						break;
					case DIGIT_OPTIONAL:
						result = new Digit();
						result.optional = true;
						break;
					case ANY:
						result = new Char();
						break;
					case ANY_OPTIONAL:
						result = new Char();
						result.optional = true;
						break;
					default:
						result = new Const();
						if (mValue == null) {
							mValue = mMaskChar;
						}
				}
			}
			result.value = mValue;
			result.valuable = mValuable;
			result.upperCase = mUpperCase;
			result.lowerCase = mLowerCase;

			return result;
		}
	}
}
