package com.humandevice.android.locationtool;

import android.content.Context;
import android.support.annotation.IntDef;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

import com.google.android.gms.location.LocationRequest;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @author Rafał Orlik
 * @date 2016-07-15
 */
public final class LocationServiceConfiguration {
	@IntDef({LocationRequest.PRIORITY_HIGH_ACCURACY, LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY, LocationRequest.PRIORITY_LOW_POWER, LocationRequest.PRIORITY_NO_POWER})
	@Retention(RetentionPolicy.SOURCE)
	public @interface LocationPriority {
	}

	private static final long DEFAULT_UPDATE_INTERVAL = 5 * 1000;
	private static final long DEFAULT_FASTEST_INTERVAL = 1000;
	private static final int DEFAULT_PRIORITY = LocationRequest.PRIORITY_HIGH_ACCURACY;

	Context mContext;
	private Long mUpdateInterval = null;
	private Long mFastestInterval = null;
	private Integer mPriority = null;

	public Context getContext() {
		return mContext;
	}

	public void setContext(@NonNull Context context) {
		mContext = context;
	}

	public long getUpdateInterval() {
		if (mUpdateInterval == null) {
			return DEFAULT_UPDATE_INTERVAL;
		}
		return mUpdateInterval;
	}

	public void setUpdateInterval(@IntRange(from = 0) long updateInterval) {
		mUpdateInterval = updateInterval;
	}

	public long getFastestInterval() {
		if (mFastestInterval == null) {
			return DEFAULT_FASTEST_INTERVAL;
		}
		return mFastestInterval;
	}

	public void setFastestInterval(@IntRange(from = 0) long fastestInterval) {
		mFastestInterval = fastestInterval;
	}

	public int getPriority() {
		if (mPriority == null) {
			return DEFAULT_PRIORITY;
		}
		return mPriority;
	}

	public void setPriority(@LocationPriority int priority) {
		mPriority = priority;
	}
}
