package com.humandevice.android.locationtool;

import android.support.annotation.FloatRange;
import android.support.annotation.IntDef;
import android.support.annotation.IntRange;

import com.google.android.gms.location.LocationRequest;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * TODO Dokumentacja
 *
 * @author Rafał Orlik
 * @date 2016-10-04
 */

public class LocationRequestBuilder {

	private long mUpdateInterval = 10 * 1000;//in milliseconds
	private long mFastestInterval = 5 * 1000;//in milliseconds
	private float mSmallestDisplacement = 0f;//in meters
	private int mPriority = LocationRequest.PRIORITY_HIGH_ACCURACY;

	public LocationRequestBuilder() {
	}

	/**
	 * @param updateInterval in millis
	 * @return
	 */
	public LocationRequestBuilder setUpdateInterval(@IntRange(from = 0) long updateInterval) {
		mUpdateInterval = updateInterval;
		return this;
	}

	/**
	 * @param fastestInterval in millis
	 * @return
	 */
	public LocationRequestBuilder setFastestInterval(@IntRange(from = 0) long fastestInterval) {
		mFastestInterval = fastestInterval;
		return this;
	}

	public LocationRequestBuilder setPriority(@LocationPriority int priority) {
		mPriority = priority;
		return this;
	}

	/**
	 * @param smallestDisplacement in meters
	 * @return
	 */
	public LocationRequestBuilder setSmallestDisplacement(@FloatRange(from = 0) Float smallestDisplacement) {
		mSmallestDisplacement = smallestDisplacement;
		return this;
	}

	public LocationRequest build() {
		LocationRequest mLocationRequest = new LocationRequest();
		mLocationRequest.setInterval(mUpdateInterval);
		mLocationRequest.setFastestInterval(mFastestInterval);
		mLocationRequest.setSmallestDisplacement(mSmallestDisplacement);
		mLocationRequest.setPriority(mPriority);
		return mLocationRequest;
	}

	@IntDef({LocationRequest.PRIORITY_HIGH_ACCURACY, LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY, LocationRequest.PRIORITY_LOW_POWER, LocationRequest.PRIORITY_NO_POWER})
	@Retention(RetentionPolicy.SOURCE)
	public @interface LocationPriority {
	}
}
