package com.humandevice.android.locationtool;

import android.Manifest;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;

import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;

import software.rsquared.androidlogger.Logger;

/**
 * TODO Dokumentacja
 *
 * @author Rafał Orlik
 * @date 2016-10-04
 */

public class LocationTool {

	private static LocationTool sLocationTool;

	private CoreLocationTool mCoreLocationTool;

	private LocationTool() {
		Context application;
		try {
			application = (Application) Class.forName("android.app.ActivityThread").getMethod("currentApplication").invoke(null, (Object[]) null);
			mCoreLocationTool = new CoreLocationTool(application);
		} catch (Exception e) {
			Logger.error(e);
		}
	}

	public static LocationTool getInstance() {
		if (sLocationTool == null) {
			sLocationTool = new LocationTool();
		}
		return sLocationTool;
	}

	/**
	 * Start location service. If there was any location listeners register them for location updates.
	 */
	@RequiresPermission(anyOf = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION})
	public void start() {
		//noinspection MissingPermission
		mCoreLocationTool.start();
	}

	/**
	 * Used to stop getting location updates.
	 */
	public void stop() {
		mCoreLocationTool.stop();
	}

	/**
	 * @see CoreLocationTool#requestLocationUpdates(LocationRequest, LocationListener, UpdateType)
	 */
	@RequiresPermission(anyOf = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION})
	public void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener) {
		//noinspection MissingPermission
		mCoreLocationTool.requestLocationUpdates(locationRequest, locationListener, UpdateType.WEAK);
	}

	/**
	 * @see CoreLocationTool#requestLocationUpdates(LocationRequest, LocationListener, UpdateType)
	 */
	@RequiresPermission(anyOf = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION})
	public void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, @NonNull UpdateType updateType) {
		//noinspection MissingPermission
		mCoreLocationTool.requestLocationUpdates(locationRequest, locationListener, updateType);
	}

	/**
	 * @see CoreLocationTool#cancelLocationUpdates
	 */
	public boolean cancelLocationUpdates(LocationListener locationListener) {
		return mCoreLocationTool.cancelLocationUpdates(locationListener);
	}

	/**
	 * @see CoreLocationTool#cancelAllWeakLocationUpdates()
	 */
	public void cancelAllWeakLocationUpdates() {
		mCoreLocationTool.cancelAllWeakLocationUpdates();
	}

	/**
	 * @see CoreLocationTool#getLastLocation()
	 */
	@RequiresPermission(anyOf = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_COARSE_LOCATION})
	public Location getLastLocation() {
		//noinspection MissingPermission
		return mCoreLocationTool.getLastLocation();
	}

	//region static methods
	public static boolean isGpsEnabled(@NonNull Context context) {
		boolean enabled = false;
		try {
			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
				int locationMode = Settings.Secure.getInt(context.getContentResolver(), Settings.Secure.LOCATION_MODE);
				enabled = locationMode == Settings.Secure.LOCATION_MODE_HIGH_ACCURACY;
			} else {
				LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
				enabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
			}
		} catch (Settings.SettingNotFoundException e) {
			Logger.error(e);
		}
		return enabled;
	}

	public static boolean isLocationEnabled(@NonNull Context context) {
		boolean enabled = false;
		try {
			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
				int locationMode = Settings.Secure.getInt(context.getContentResolver(), Settings.Secure.LOCATION_MODE);
				enabled = locationMode != Settings.Secure.LOCATION_MODE_OFF;
			} else {
				LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
				enabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
			}
		} catch (Settings.SettingNotFoundException e) {
			Logger.error(e);
		}
		return enabled;
	}

	public static void requestGpsPermission(Activity activity, int requestCode) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			activity.requestPermissions(new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, requestCode);
		}
	}

	public static void requestGpsPermission(Fragment fragment, int requestCode) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			fragment.requestPermissions(new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, requestCode);
		}
	}

	public static void requestGpsPermission(android.support.v4.app.Fragment fragment, int requestCode) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			fragment.requestPermissions(new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, requestCode);
		}
	}

	public static boolean checkGpsPermission(Activity activity) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return activity.checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED;
		}
		return true;
	}

	public static boolean checkLocationPermission(Activity activity) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return activity.checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED
					|| activity.checkSelfPermission(Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED;
		}
		return true;
	}
	//endregion

}
