package com.humandevice.android.mvpframework;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.android.core.layers.LayerView;

/**
 * Basic implementation for {@link Presenter} methods
 *
 * @author Rafał Zajfert
 * @date 18.02.2016
 */
public abstract class BasicPresenter<V extends LayerView> implements Presenter<V> {

	@Nullable
	protected V mView;

	@Override
	public void onCreate(@Nullable PresenterBundle bundle) {
	}

	@Override
	public void onPause() {
	}

	@Override
	public void onResume() {
	}

	@Override
	public void onDestroy() {
	}

	@Override
	public void onSaveInstanceState(@NonNull PresenterBundle bundle) {
	}

	@Override
	@CallSuper
	public void onBindView(@NonNull V view) {
		mView = view;
	}

	@Override
	@CallSuper
	public void onUnbindView() {
		mView = null;
	}
}
