package com.humandevice.android.mvpframework;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.android.core.layers.LayerView;

/**
 * @date 18.02.2016
 */
public interface Presenter<V extends LayerView> {

    void onCreate(@Nullable PresenterBundle bundle);

    void onDestroy();

    void onPause();

    void onResume();

    void onSaveInstanceState(@NonNull PresenterBundle bundle);

    void onBindView(V view);

    void onUnbindView();
}
