package com.humandevice.android.mvpframework;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.transition.Fade;
import android.view.View;

import com.humandevice.android.core.view.ToolsActivity;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @date 18.02.2016
 */
public class PresenterActivity extends ToolsActivity implements PresenterCache {
    private static final String NEXT_ID_KEY = "next-presenter-id";

    private NonConfigurationInstance mNonConfigurationInstance;

    @Override
    @CallSuper
    protected void onCreate(Bundle savedInstanceState) {
        mNonConfigurationInstance = (NonConfigurationInstance) getLastCustomNonConfigurationInstance();
        if (mNonConfigurationInstance == null) {
            long seed = savedInstanceState == null ? 0 : savedInstanceState.getLong(NEXT_ID_KEY);
            mNonConfigurationInstance = new NonConfigurationInstance(seed);
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    @CallSuper
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(NEXT_ID_KEY, mNonConfigurationInstance.mNextId.get());
    }

    @Override
    public Object onRetainCustomNonConfigurationInstance() {
        return mNonConfigurationInstance;
    }

    @Override
    public long generateId() {
        return mNonConfigurationInstance.mNextId.getAndIncrement();
    }

    @Override
    public final <T extends Presenter> T getPresenter(long index) {
        try {
            //noinspection unchecked
            return (T) mNonConfigurationInstance.mPresenterMap.get(index);
        } catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPresenter(long index, Presenter presenter) {
        mNonConfigurationInstance.mPresenterMap.put(index, presenter);
    }

    private static class NonConfigurationInstance {
        private Map<Long, Presenter> mPresenterMap;
        private AtomicLong mNextId;

        public NonConfigurationInstance(long seed) {
            mPresenterMap = new HashMap<>();
            mNextId = new AtomicLong(seed);
        }
    }
}
