package com.humandevice.android.mvpframework;

import android.os.Bundle;

import com.rafalzajfert.androidlogger.Logger;

import java.util.HashMap;

/**
 * @date 18.02.2016
 */
class PresenterBundleUtils {
    private static final String KEY_PREFIX = PresenterBundle.class.getName() + "-";

    private PresenterBundleUtils() {
        // No instances
    }

    public static PresenterBundle getPresenterBundle(Bundle savedInstanceState, long presenterId) {
        HashMap<String, Object> map = null;
        if (savedInstanceState != null) {
            try {
                //noinspection unchecked
                map = (HashMap<String, Object>) savedInstanceState.getSerializable(KEY_PREFIX + presenterId);
            } catch (ClassCastException e) {
                Logger.error(e);
            }
        }
        PresenterBundle result = null;
        if (map != null) {
            result = new PresenterBundle();
            result.setMap(map);
        }
        return result;
    }

    public static void setPresenterBundle(Bundle outState, PresenterBundle presenterBundle, long presenterId) {
        outState.putSerializable(KEY_PREFIX + presenterId, presenterBundle.getMap());
    }
}
