package com.humandevice.android.mvpframework;

import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Basic implementation for {@link Presenter} methods
 *
 * @author Rafał Zajfert
 * @date 18.02.2016
 */
public abstract class BasicPresenter<V extends LayerView> implements Presenter<V> {

	@Nullable
	protected V view;

	@Override
	public void onCreate(@Nullable Bundle bundle) {
	}

	@Override
	public void onPause() {
	}

	@Override
	public void onResume() {
	}

	@Override
	public void onDestroy() {
	}

	@Override
	public void onSaveInstanceState(@NonNull Bundle bundle) {
	}

	@Override
	@CallSuper
	public void onBindView(@NonNull V view) {
		this.view = view;
	}

	@Override
	@CallSuper
	public void onUnbindView() {
		view = null;
	}
}
