package com.humandevice.android.mvpframework;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;


/**
 * @date 18.02.2016
 */
public interface Presenter<V extends LayerView> {

    void onCreate(@Nullable Bundle bundle);

    void onDestroy();

    void onPause();

    void onResume();

    void onSaveInstanceState(@NonNull Bundle bundle);

    void onBindView(V view);

    void onUnbindView();
}
