package com.humandevice.android.mvpframework;

import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.v4.util.LongSparseArray;
import android.support.v7.app.AppCompatActivity;
import android.view.ViewGroup;

import java.util.concurrent.atomic.AtomicLong;

/**
 * @date 18.02.2016
 */
public class PresenterActivity extends AppCompatActivity implements PresenterCache {
    private static final String NEXT_ID_KEY = "next-presenter-id";

    private NonConfigurationInstance nonConfigurationInstance;

    @Override
    @CallSuper
    protected void onCreate(Bundle savedInstanceState) {
        nonConfigurationInstance = (NonConfigurationInstance) getLastCustomNonConfigurationInstance();
        if (nonConfigurationInstance == null) {
            long seed = savedInstanceState == null ? 0 : savedInstanceState.getLong(NEXT_ID_KEY);
            nonConfigurationInstance = new NonConfigurationInstance(seed);
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    @CallSuper
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(NEXT_ID_KEY, nonConfigurationInstance.nextId.get());
    }

    @Override
    public Object onRetainCustomNonConfigurationInstance() {
        return nonConfigurationInstance;
    }

    @Override
    public long generateId() {
        return nonConfigurationInstance.nextId.getAndIncrement();
    }

    @Override
    public final <T extends Presenter> T getPresenter(long index) {
        try {
            //noinspection unchecked
            return (T) nonConfigurationInstance.presenters.get(index);
        } catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPresenter(long index, Presenter presenter) {
        nonConfigurationInstance.presenters.put(index, presenter);
    }
    
	public ViewGroup getRootView() {
		return (ViewGroup) this.findViewById(android.R.id.content);
	}
    
    
    private static class NonConfigurationInstance {
        private LongSparseArray<Presenter> presenters;
        private AtomicLong nextId;

        NonConfigurationInstance(long seed) {
            presenters = new LongSparseArray<>();
            nextId = new AtomicLong(seed);
        }
    }
}
