package com.humandevice.android.mvpframework;

import android.os.Bundle;

/**
 * @date 18.02.2016
 */
class PresenterBundleUtils {
	private static final String KEY_PREFIX = Bundle.class.getName() + "-";
	
	private PresenterBundleUtils() {
		// No instances
	}
	
	static Bundle getPresenterBundle(Bundle savedInstanceState, long presenterId) {
		if (savedInstanceState != null) {
			return savedInstanceState.getBundle(KEY_PREFIX + presenterId);
		}
		return null;
	}
	
	static void setPresenterBundle(Bundle outState, Bundle presenterBundle, long presenterId) {
		outState.putBundle(KEY_PREFIX + presenterId, presenterBundle);
	}
}
