package com.humandevice.android.mvpframework;

import android.support.annotation.NonNull;

import java.lang.reflect.Constructor;

/**
 * @author Rafał Zajfert
 * @date 18.02.2016
 */
class PresenterFactory {

    private PresenterFactory() {
    }

    /**
     * Create {@link Presenter} instance
     *
     * @param presenter class of the presenter implementation
     */
    @SuppressWarnings("unchecked")
    public static <P extends Presenter> P create(@NonNull Class<P> presenter) {
        Constructor<?> constructor;
        try {
            constructor = presenter.getConstructor();
        } catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Default constructor not found in " + presenter.getSimpleName() + " class", e);
        }
        try {
            return (P) constructor.newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException("Cannot create instance for the " + presenter.getSimpleName() + " class", e);
        }
    }
}
