package com.humandevice.resttools.rest;

import okhttp3.MediaType;

/**
 * Klasa konfigurująca dane dostępowe do resta, takie jak host, port itp.
 *
 * @author Szymon Bartczak
 * @date 2016-05-05
 */
public class RestConfig {

    public final int ALIVE_DURATION;
    public static final int DEF_ALIVE_DURATION = 5 * 60 * 1000;

    public static final MediaType DEF_MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    public final MediaType MEDIA_TYPE;

    public static final String DEF_CONTENT_TYPE = "Content-Type";
    public final String CONTENT_TYPE;

    public final String API_SCHEME;
    public static final String DEF_API_SCHEME = "http";

    public final String API_HOST;

    public final String API_VERSION;
    public static final String DEF_API_VERSION = "v1";

    public final int API_PORT;
    public static final int DEF_API_PORT = 80;

    public final boolean API_BASIC_AUTH;
    public final String API_BASIC_USER;
    public final String API_BASIC_PASSWORD;

    public RestConfig(String apiScheme, String apiHost, String apiVersion, int apiPort, boolean apiBasicAuth, String apiBasicUser, String
            apiBasicPassword, int aliveDuration, String contentType, MediaType mediaType) {
        API_SCHEME = apiScheme;
        API_HOST = apiHost;
        API_VERSION = apiVersion;
        API_PORT = apiPort;
        API_BASIC_AUTH = apiBasicAuth;
        API_BASIC_USER = apiBasicUser;
        API_BASIC_PASSWORD = apiBasicPassword;
        ALIVE_DURATION = aliveDuration;
        CONTENT_TYPE = contentType;
        MEDIA_TYPE = mediaType;
    }

    public RestConfig(String apiHost) {
        this(DEF_API_SCHEME, apiHost, DEF_API_VERSION, DEF_API_PORT, false, "", "", DEF_ALIVE_DURATION,
                DEF_CONTENT_TYPE, DEF_MEDIA_TYPE);
    }
}
