package com.humandevice.resttools.rest;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.resttools.rest.exceptions.RequestException;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 01.03.2016
 */
public class RequestFutureTask<V> extends FutureTask<V> implements RequestFuture<V> {

    private RequestListener<V> mListener;
    private static Handler mHandler;

    public RequestFutureTask(@NonNull Callable<V> callable) {
        super(callable);
    }

    public RequestFutureTask(@NonNull Callable<V> callable, @Nullable RequestListener<V> listener) {
        super(callable);
        mListener = listener;
    }

    @Override
    public V get() throws RequestException {
        try {
            return super.get();
        }catch (ExecutionException | InterruptedException e){
            throw parseException(e);
        }
    }

    @Override
    public V get(long timeout, @NonNull TimeUnit unit) throws RequestException {
        try{
            return super.get(timeout, unit);
        } catch (ExecutionException | InterruptedException | TimeoutException e) {
            throw parseException(e);
        }
    }

    @Override
    protected void done() {
        if (mListener != null) {
            getHandler().post(new Runnable() {
                @Override
                public void run() {
                    mListener.done(RequestFutureTask.this);
                }
            });
        }
        super.done();
    }

    /**
     * parsowanie błędów do {@link RequestException}
     * @param e
     * @return
     */
    private RequestException parseException(Exception e)  {
        Throwable cause = e.getCause();
        if (cause !=null && cause instanceof RequestException){
            return (RequestException) cause;
        }else {
            return new RequestException(e);
        }
    }

    public Handler getHandler() {
        if (mHandler == null){
            mHandler = new Handler(Looper.getMainLooper());
        }
        return mHandler;
    }
}
