package com.humandevice.resttools.service;

import com.humandevice.resttools.model.Token;
import com.humandevice.resttools.rest.exceptions.RefreshTokenException;

/**
 * Intefejs zapewniający podstawowe metody UserService.
 *
 * @author Szymon Bartczak
 * @date 2016-05-04
 */
public interface UserService {

    /**
     * @return true jeśli użytkownik akutalnie jest zalogowany.
     */
    boolean isLogged();

    /**
     * @return true jeżeli token uwierzytelniający wciąż jest poprawny tzn. czy np. nie wygasł.
     */
    boolean isTokenValid();

    /**
     * Próbuje odświeżyć token uwierzytelniający.
     * @throws RefreshTokenException jeżeli wystąpił błąd podczas odświeżania.
     */
    void refreshToken() throws RefreshTokenException;

    /**
     * @return token uwierzytelniający.
     */
    <T extends Token> T getToken();

    /**
     * Wylogowuje użytkownika, czyszcząc przy tym zapamiętane tokeny.
     */
    void logout();
}
