package com.humandevice.android.resttools.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * Jackson Singleton.
 *
 * @author Mikołaj Styś
 * @date 2016/05/06
 */
public final class JacksonMapper {

    private final ObjectMapper mObjectMapper = new ObjectMapper();
    private final ObjectWriter mObjectWriter = mObjectMapper.writer();
    private static JacksonMapper sInstance;

    public static JacksonMapper getInstance() {
        if (sInstance == null) {
            sInstance = new JacksonMapper();
        }
        return sInstance;
    }

    private JacksonMapper() {
        mObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mObjectMapper.registerModule(new SimpleModule());
    }

    public ObjectReader getReaderFor(TypeReference<?> type) {
        return mObjectMapper.readerFor(type);
    }

    public ObjectReader getReaderFor(Class<?> cls) {
        return mObjectMapper.readerFor(cls);
    }

    public ObjectMapper getObjectMapper() {
        return mObjectMapper;
    }

    public ObjectWriter getObjectWriter() {
        return mObjectWriter;
    }
}
