package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.android.resttools.rest.exceptions.RequestException;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-07
 */
public class RequestPool {

	private Map<Integer, Request> mRequestPool = new LinkedHashMap<>();
	private Map<Integer, PostTask> mPostTaskMap = new LinkedHashMap<>();

	private boolean mExecuted;

	private boolean mThrowIfAnyFails = true;

	private RequestExecutor mExecutor;
	private Iterator<Map.Entry<Integer, Request>> mExecuteIterator;
	private RequestPoolListener mListener;
	private Map<Integer, RequestFuture> mDoneTasks = new LinkedHashMap<>();
	private Map.Entry<Integer, Request> mCurrentExecutedTask;

	public RequestPool() {
		mExecutor = new RequestExecutor(1, 0L);
	}

	public RequestPool addTask(@NonNull Request request, int requestCode) {
		return addTask(request, requestCode, null);
	}

	public RequestPool addTask(@NonNull Request request, int requestCode, @Nullable PostTask postTask) {
		if (mExecuted) {
			throw new IllegalStateException("New task cannot be added to the pool after executing.");
		}
		if (mRequestPool.containsKey(requestCode)) {
			throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ")is already added.");
		}
		mRequestPool.put(requestCode, request);
		if (postTask != null) {
			mPostTaskMap.put(requestCode, postTask);
		}
		return this;
	}

	public void setThrowIfAnyFails(boolean throwIfAnyFails) {
		mThrowIfAnyFails = throwIfAnyFails;
	}

	public void execute(RequestPoolListener listener) {
		if (mExecuted){
			throw new IllegalStateException("Already executed.");
		}
		mExecuted = true;
		mExecuteIterator = mRequestPool.entrySet().iterator();
		mListener = listener;

		executeNext();
	}

	private void executeNext() {
		if (mExecuteIterator.hasNext()) {
			mCurrentExecutedTask = mExecuteIterator.next();
			mExecutor.submit(mCurrentExecutedTask.getValue().createRequestTask(), mRequestListener);
		} else if (mListener != null) {
			mListener.done(mDoneTasks);
		}
	}

	private RequestListener mRequestListener = new RequestListener() {
		@Override
		public void done(@NonNull RequestFuture task) {
			if (mThrowIfAnyFails) {
				try {
					task.get();
				} catch (RequestException e) {
					if (mListener != null) {
						mListener.fail(task);
					}
					return;
				}
			}
			mDoneTasks.put(mCurrentExecutedTask.getKey(), task);
			if (mPostTaskMap.containsKey(mCurrentExecutedTask.getKey())){
				mPostTaskMap.get(mCurrentExecutedTask.getKey()).onPost(task);
			}
			executeNext();
		}
	};


	public interface PostTask {
		void onPost(RequestFuture task);
	}
}
