package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;

import com.humandevice.android.resttools.rest.exceptions.RequestException;
import com.humandevice.android.resttools.rest.listeners.RequestListener;
import com.humandevice.android.resttools.rest.listeners.RequestPoolListener;

import java.util.HashMap;
import java.util.Map;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-07
 */
public class ThreadRequestPool extends RequestPool {

	private Map<RequestFuture, Integer> mExecutedTasks = new HashMap<>();

	public ThreadRequestPool(int poolSize) {
		super(poolSize);
	}

	public void execute(RequestPoolListener listener) {
		if (mExecuted) {
			throw new IllegalStateException("Already executed.");
		}
		mExecuted = true;

		mListener = listener;
		for (Map.Entry<Integer, Request> entry : mRequestPool.entrySet()) {
			mExecutedTasks.put(mExecutor.submit(entry.getValue().createRequestTask(), mRequestListener), entry.getKey());
		}
		mExecutor.shutdown();
	}

	private RequestListener mRequestListener = new RequestListener() {
		@Override
		public void done(@NonNull RequestFuture task) {

			Integer requestCode = mExecutedTasks.get(task);
			try {
				task.get();
			} catch (RequestException e) {
				if (mListener != null) {
					if (mListener.fail(e, requestCode)) {
						stopExecute();
					}
				}
				if (mStopIfFail) {
					stopExecute();
				}
			}

			mDoneTasks.put(requestCode, task);
			if (mPostTaskMap.containsKey(requestCode)) {
				try {
					//noinspection unchecked
					mPostTaskMap.get(requestCode).onPost(task);
				} catch (RequestException ignored) {
					//RequestPoolListener.fail() will be thrown
				}
			}

			if (mDoneTasks.size() == mExecutedTasks.size()){
				if (mListener != null) {
					try {
						mListener.done(mDoneTasks);
					} catch (RequestException ignored) {
						//RequestPoolListener.fail() will be thrown
					}
				}
			}
		}
	};

	private void stopExecute() {
		mExecutor.shutdownNow();
	}


	public interface PostTask<T> {
		void onPost(RequestFuture<T> task) throws RequestException;
	}
}
