package com.humandevice.android.resttools.rest;

import android.text.TextUtils;

import com.humandevice.android.resttools.rest.exceptions.ErrorResponse;
import com.humandevice.android.resttools.service.IUserService;

import okhttp3.Credentials;

/**
 * Klasa konfigurująca dane dostępowe do resta, takie jak host, port itp.
 *
 * @author Szymon Bartczak
 * @date 2016-05-05
 */
public class RestConfiguration {

    int mTimeout = 60 * 1000;

    String mApiScheme = "http";
    String mApiHost;
    int mApiPort = 80;
    String mAuthorization;
    String mAuthorizationUser;
    String mAuthorizationPassword;
    boolean mCastBooleanToInt;
    Request.ConnectionRestriction mConnectionRestriction;
    Class<? extends IUserService> mUserServiceClass;
    Class<? extends ErrorResponse> mErrorResponseClass;


    /**
     *  default: 1min
     */
    public RestConfiguration setTimeout(int timeout) {
        mTimeout = timeout;
        return this;
    }

    /**
     * default: http
     */
    public RestConfiguration setApiScheme(String apiScheme) {
        mApiScheme = apiScheme;
        return this;
    }

    public RestConfiguration setApiHost(String apiHost) {
        mApiHost = apiHost;
        return this;
    }

    /**
     * default: 80
     */
    public RestConfiguration setApiPort(int apiPort) {
        mApiPort = apiPort;
        return this;
    }

    public RestConfiguration setAuthorization(String user, String password) {
        if (TextUtils.isEmpty(user) && TextUtils.isEmpty(password)){
            mAuthorization = null;
            return this;
        }
        mAuthorization = Credentials.basic(user, password);
        mAuthorizationUser = user;
        mAuthorizationPassword = password;
        return this;
    }

    /**
     * cast all boolean parameters to int value (0/1)
     */
    public RestConfiguration setCastBooleanToInt() {
        mCastBooleanToInt = true;
        return this;
    }

    /**
     * Sprawdzenie czy request może zostać wykonany
     */
    public RestConfiguration setConnectionRestriction(Request.ConnectionRestriction connectionRestriction) {
        mConnectionRestriction = connectionRestriction;
        return this;
    }

	/**
     * Ustawienie klasy singletona serwisu użytkownika
     */
    public RestConfiguration setUserServiceClass(Class<? extends IUserService> userServiceClass) {
        mUserServiceClass = userServiceClass;
        return this;
    }

	/**
     * Ustawienie klasy odpowiedzi błędu
     */
    public RestConfiguration setErrorResponseClass(Class<? extends ErrorResponse> errorResponseClass) {
        mErrorResponseClass = errorResponseClass;
        return this;
    }

    public int getTimeout() {
        return mTimeout;
    }

    public String getApiScheme() {
        return mApiScheme;
    }

    public String getApiHost() {
        return mApiHost;
    }

    public int getApiPort() {
        return mApiPort;
    }

    public String getAuthorization() {
        return mAuthorization;
    }

    public String getAuthorizationUser() {
        return mAuthorizationUser;
    }

    public String getAuthorizationPassword() {
        return mAuthorizationPassword;
    }

    public boolean isCastBooleanToInt() {
        return mCastBooleanToInt;
    }

    public Request.ConnectionRestriction getConnectionRestriction() {
        return mConnectionRestriction;
    }

    public Class<? extends IUserService> getUserServiceClass() {
        return mUserServiceClass;
    }

    public Class<? extends ErrorResponse> getErrorResponseClass() {
        return mErrorResponseClass;
    }
}
