package com.humandevice.android.resttools.adapters;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.rafalzajfert.androidlogger.Logger;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

/**
 * Jackson Singleton.
 *
 * @author Mikołaj Styś
 * @date 2016/05/06
 */
public final class JacksonMapper {

	private final ObjectMapper mObjectMapper = new ObjectMapper();
	private final ObjectWriter mObjectWriter = mObjectMapper.writer();

	public static JacksonMapper getInstance(boolean unixTime) {
		return new JacksonMapper(unixTime);
	}

	private JacksonMapper(final boolean unixTime) {
		mObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
		SimpleModule module = new SimpleModule();
		if (unixTime) {
			module.addDeserializer(Calendar.class, new JsonDeserializer<Calendar>() {
				@Override
				public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
					long value = p.getLongValue();
					Logger.error("Calendar",value);
					Calendar calendar = Calendar.getInstance();
					calendar.setTimeInMillis(value / 1000);
					return calendar;
				}
			});
			module.addDeserializer(Date.class, new JsonDeserializer<Date>() {
				@Override
				public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
					long value = p.getLongValue();
					Logger.error("Date",value);
					return new Date(value / 1000);
				}
			});
		}
		mObjectMapper.registerModule(module);
	}

	public ObjectReader getReaderFor(TypeReference<?> type) {
		return mObjectMapper.readerFor(type);
	}

	public ObjectReader getReaderFor(Class<?> cls) {
		return mObjectMapper.readerFor(cls);
	}

	public ObjectMapper getObjectMapper() {
		return mObjectMapper;
	}

	public ObjectWriter getObjectWriter() {
		return mObjectWriter;
	}
}
