package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.android.resttools.rest.exceptions.RequestException;
import com.humandevice.android.resttools.rest.listeners.PoolRequestListener;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 */
public abstract class PoolRequest<P extends PoolRequest> {

	protected Map<Integer, Request> mRequestPool = new LinkedHashMap<>();
	protected Map<Integer, PostTask> mPostTaskMap = new LinkedHashMap<>();

	protected boolean mExecuted;
	protected boolean mStopIfFail = false;

	protected RequestExecutor mExecutor;

	protected PoolRequest(int poolSize){
		mExecutor = new RequestExecutor(poolSize, 0L);
	}

	public <T> P addTask(@NonNull Request<T> request, int requestCode) {
		return addTask(request, requestCode, null);
	}

	public <T> P addTask(@NonNull Request<T> request, int requestCode, @Nullable PostTask<T> postTask) {
		if (mExecuted) {
			throw new IllegalStateException("New task cannot be added to the pool after executing.");
		}
		if (mRequestPool.containsKey(requestCode)) {
			throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ")is already added.");
		}
		mRequestPool.put(requestCode, request);
		if (postTask != null) {
			mPostTaskMap.put(requestCode, postTask);
		}
		//noinspection unchecked
		return (P) this;
	}

	public P setStopIfFail() {
		mStopIfFail = true;
		//noinspection unchecked
		return (P) this;
	}

	public abstract void execute(PoolRequestListener listener);


	public interface PostTask<T> {
		void onPost(RequestFuture<T> task) throws RequestException;
	}

	public void stopExecute() {
		mExecutor.shutdownNow();
	}
}
